%------------------------------------------------------------------------------
% File     : SYO535^1 : TPTP v7.4.0. Released v5.2.0.
% Domain   : Syntactic
% Problem  : Choice on relations between individuals and functions
% Version  : Especial.
% English  : 

% Refs     : [Bro11] Brown E. (2011), Email to Geoff Sutcliffe
% Source   : [Bro11]
% Names    : CHOICE12 [Bro11]

% Status   : Theorem
% Rating   : 0.00 v7.4.0, 0.22 v7.2.0, 0.12 v7.1.0, 0.25 v7.0.0, 0.14 v6.4.0, 0.17 v6.3.0, 0.20 v6.2.0, 0.43 v6.1.0, 0.29 v5.5.0, 0.50 v5.4.0, 0.60 v5.2.0
% Syntax   : Number of formulae    :    9 (   0 unit;   4 type;   2 defn)
%            Number of atoms       :   31 (   2 equality;  20 variable)
%            Maximal formula depth :    8 (   6 average)
%            Number of connectives :   22 (   0   ~;   0   |;   0   &;  19   @)
%                                         (   0 <=>;   3  =>;   0  <=;   0 <~>)
%                                         (   0  ~|;   0  ~&)
%            Number of type conns  :   31 (  31   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :    6 (   4   :;   0   =)
%            Number of variables   :   12 (   0 sgn;   3   !;   5   ?;   4   ^)
%                                         (  12   :;   0  !>;   0  ?*)
%                                         (   0  @-;   0  @+)
% SPC      : TH0_THM_EQU_NAR

% Comments : Choice operators on i and ii are used to define a choice operator 
%            on i*ii (Curried).
%------------------------------------------------------------------------------
thf(eps,type,(
    eps: ( $i > $o ) > $i )).

thf(choiceax,axiom,(
    ! [P: $i > $o] :
      ( ? [X: $i] :
          ( P @ X )
     => ( P @ ( eps @ P ) ) ) )).

thf(epsii,type,(
    epsii: ( ( $i > $i ) > $o ) > $i > $i )).

thf(choiceaxii,axiom,(
    ! [P: ( $i > $i ) > $o] :
      ( ? [X: $i > $i] :
          ( P @ X )
     => ( P @ ( epsii @ P ) ) ) )).

thf(epsa,type,(
    epsa: ( $i > ( $i > $i ) > $o ) > $i )).

thf(epsad,definition,
    ( epsa
    = ( ^ [R: $i > ( $i > $i ) > $o] :
          ( eps
          @ ^ [X: $i] :
            ? [Y: $i > $i] :
              ( R @ X @ Y ) ) ) )).

thf(epsb,type,(
    epsb: ( $i > ( $i > $i ) > $o ) > $i > $i )).

thf(epsbd,definition,
    ( epsb
    = ( ^ [R: $i > ( $i > $i ) > $o] :
          ( epsii
          @ ^ [Y: $i > $i] :
              ( R @ ( epsa @ R ) @ Y ) ) ) )).

thf(conj,conjecture,(
    ! [R: $i > ( $i > $i ) > $o] :
      ( ? [X: $i,Y: $i > $i] :
          ( R @ X @ Y )
     => ( R @ ( epsa @ R ) @ ( epsb @ R ) ) ) )).

%------------------------------------------------------------------------------
